require(['jquery'], function ($) {
  $(document).ready(function() {
    var saveForm = $('#xpollSaveForm');
    var submitInput = saveForm.find("input[type='submit']");
    saveForm.submit(function(event) {
      event.preventDefault();
      $.ajax({
        type: $(this).attr('method'),
        url : $(this).attr('action'),
        data: $(this).serialize(),
        beforeSend: function() {
          this.progressNotification = new XWiki.widgets.Notification("Saving...", 'inprogress');
          // disable Save button
          submitInput.prop('disabled', true);
        },
        complete:function() {
          // disable inprogress notification widget
          this.progressNotification.hide();
        },
        success: function(data) {
          new XWiki.widgets.Notification("Saved", 'done');
        },
        error: function(data) {
          new XWiki.widgets.Notification("Failed to save the document. Reason: HTTP", 'error');
          // enable Save button
          submitInput.prop('disabled', false);
        }
      });
    });
  });
});
