'use strict';
/**
 * Start the real script.
 */
require(['jquery'], function ($) {

  /**
   * Page initialization
   */
  $(document).ready(function() {

    /**
     * Handle the notification email interval
     */
    $('.notificationEmailInterval').change(function () {
      var intervalSelect = $(this);
      var notification = new XWiki.widgets.Notification("Your settings are being saved...", 'inprogress');
      var serviceURL = new XWiki.Document(XWiki.Model.resolve('XWiki.Notifications.Code.NotificationPreferenceService', XWiki.EntityType.DOCUMENT)).getURL('get', 'outputSyntax=plain');
      $.post(serviceURL, {
        'interval': intervalSelect.val()
      }).done(function (data) {
        notification.hide();
        new XWiki.widgets.Notification("Saved!", 'done');
      });
    });

    /**
     * Handle the include diff in email setting
     */
    $('.notificationEmailDiffType').change(function () {
      var diffTypeSelect = $(this);
      var notification = new XWiki.widgets.Notification("Your settings are being saved...", 'inprogress');
      var serviceURL = new XWiki.Document(XWiki.Model.resolve('XWiki.Notifications.Code.NotificationPreferenceService', XWiki.EntityType.DOCUMENT)).getURL('get', 'outputSyntax=plain');
      $.post(serviceURL, {
        'diffType': diffTypeSelect.val(),
        'target': $('.notifEmailPreferences').attr('data-target')
      }).done(function (data) {
        notification.hide();
        new XWiki.widgets.Notification("Saved!", 'done');
      }).fail(function (data) {
        notification.hide();
        new XWiki.widgets.Notification("Failed to save your settings", 'error');
      });
    });

  });
});

