require(['https://maps.google.com/maps/api/js'], function() {
  'use strict';

  XWiki.map = Class.create({
    /*
    ** Load a map centered on the given location
    */
    initialize: function(element, location, options) {
      this.element = $(element);
      // Default option values
      this.options = (options !== undefined && typeof options == 'object' ) ? options : {};
      this.options.info         = this.options.info !== undefined         ? this.options.info : '';
      this.options.zoom         = this.options.zoom !== undefined         ? this.options.zoom : 15;
      this.options.showErrors   = this.options.showErrors !== undefined   ? this.options.showErrors : true;
      this.options.locationType = this.options.locationType !== undefined ? this.options.locationType : 'address';
      // Get the exact geolocalization
      var geocoder = new google.maps.Geocoder();
      geocoder.geocode( { 'address': location }, function(results, status) {
        if (status == google.maps.GeocoderStatus.OK) {
          var latLng;
          
          // Check if the location type is Geographic Coordinate
          if (this.options.locationType == 'latlng') {
            // get the latitude and longitude
            var latlng = location.split(',');
            var lat = latlng[0];
            var lng = latlng[1];
            latLng = new google.maps.LatLng(lat,lng);
          } else {
            latLng = results[0].geometry.location;
          }

          // Create map
          var mapOptions = {
            zoom: this.options.zoom,
            center: latLng,
            mapTypeId: google.maps.MapTypeId.ROADMAP
          };
          this.map = new google.maps.Map(this.element, mapOptions);

          // Create marker
          var marker = new google.maps.Marker({
            map: this.map,
            position: latLng
          });

          // Create info window
          if (this.options.info != '') {
            var infoWindow = new google.maps.InfoWindow({
              content: this.options.info
            });
            infoWindow.open(this.map, marker);
          }
        } else if (this.options.showErrors) {
          new XWiki.widgets.Notification('Error: ' + status, 'error');
        }

        // Fire status event
        // Status codes: OK, ZERO_RESULTS, OVER_QUERY_LIMIT, REQUEST_DENIED, INVALID_REQUEST, UNKNOWN_ERROR
        // Documentation: https://developers.google.com/maps/documentation/geocoding/#StatusCodes
        this.element.fire('GMAPS:' + status);
      }.bind(this));
    }
  });

  var init = function() {
    $$('.xwiki-map-container').each(function(item) {
      var options = {};
      if (item.textContent) {
        options.info = item.textContent;
      }
      var zoom = $w(item.className).detect(function(c) { return c.startsWith('zoom-')});
      if (zoom) {
        options.zoom = zoom.substring(5) - 0;
      }
      options.locationType = item.hasClassName('locationType-address') ? 'address' : 'latlng';
      options.showErrors   = item.hasClassName('errors-show');
      new XWiki.map(item, item.title, options);
    });
  };
  
  (XWiki && XWiki.domIsLoaded && init()) || document.observe('xwiki:dom:loaded', init);
});

