// Set the event listeners
document.observe('GMAPS:ZERO_RESULTS', handleMapError.bind(this));
document.observe('GMAPS:OVER_QUERY_LIMIT', handleMapError);
document.observe('GMAPS:REQUEST_DENIED', handleMapError);
document.observe('GMAPS:INVALID_REQUEST', handleMapError);
document.observe('GMAPS:UNKNOWN_ERROR', handleMapError);

// Handle the error
function handleMapError(event) {
  var map = event.element();

  // Hide the map area which in this case is just whitespace
  map.hide();

  // Set the displayMap property to false and add a message next to it in edit mode
  new Ajax.Request
  (
    'http://wiki.linghuchongtech.com:80/wiki/bin/view/Meeting/DeactivateMapService',
    {
      method: 'get',
      parameters: { xpage: 'plain', outputSyntax: 'plain', meetingDoc: XWiki.currentSpace + '.' + XWiki.currentPage, error: event.eventName}
    }
  );
}

// Reset message when in edit mode
var displayMap = $('Meeting.MeetingClass_0_displayMap');

if(displayMap) {
  // Check if already checked from outside the edit UI (ex: object mode)
  if(displayMap.checked) {
    var label = displayMap.up().down('label');
    label ? label.remove():null;
    displayMap.insert({ after: '<input type="hidden" value="" name="Meeting.MeetingClass_0_displayMapError" id="Meeting.MeetingClass_0_displayMapError">' });
  }

  // Upon reactivation, remove message
  displayMap.observe('click', function() {
    if(this.checked) {
      displayMap.insert({ after: '<input type="hidden" value="" name="Meeting.MeetingClass_0_displayMapError" id="Meeting.MeetingClass_0_displayMapError">' });
    } else if ($('Meeting.MeetingClass_0_displayMapError')) {
      $('Meeting.MeetingClass_0_displayMapError').remove();
    }
  });

  //Upon updating location remove message
  $('Meeting.MeetingClass_0_place').observe('change', function() {
    if(!$('Meeting.MeetingClass_0_displayMapError')) {
      displayMap.insert({ after: '<input type="hidden" value="" name="Meeting.MeetingClass_0_displayMapError" id="Meeting.MeetingClass_0_displayMapError">' });
    }
  });
  }
require(['jquery'], function ($) {
  $(document).ready(function() {
    var notifForm = $("#sendNotification");
    var notifSubmitInput = notifForm.find("input[type='submit']");
    notifForm.submit(function(event) {
      event.preventDefault();
      $.ajax({
        type: $(this).attr('method'),
        url : $(this).attr('action'),
        data: $(this).serialize(),
        beforeSend: function() {
          this.progressNotification = new XWiki.widgets.Notification("Sending notification...", 'inprogress');
          notifSubmitInput.attr('disabled', 'disabled');
        },
        complete:function() {
          // disable inprogress notification widget
          this.progressNotification.hide();
        },
        success: function(data) {
          new XWiki.widgets.Notification(data['notification'], data['status']);
        },
        error: function(data) {
          if(data.responseJSON) {
            new XWiki.widgets.Notification(data.responseJSON['notification'], data.responseJSON['status']);
          } else {
            new XWiki.widgets.Notification("There was an error sending your request. Please try again.", 'error');
          }
          notifSubmitInput.removeAttr('disabled');
        }
      });
    });
  });
});

