
(function(){
  var forums = {
    tableId : 'forums',
    /* Refreshs the livetable livetable_forums */
    refreshLiveTable : function(){
      if(livetable_forums){
        var lt = livetable_forums;
        lt.totalRows = -1;
        lt.showRows(1, lt.limit);
	  }
    },
    /* Deletes the forum, the space of the forum is set in the elem as attribute (space) */
    deleteForum : function(elem){
      var $elem = $(elem)
      if($elem.clickDesibled){
        return;
      }
      var space = $elem.readAttribute('space');
      new XWiki.widgets.ConfirmedAjaxRequest(
        /* Ajax request URL */
        "http://wiki.linghuchongtech.com:80/wiki/bin/get/ForumCode/Actions?outputSyntax=plain",
        {
          /* Ajax request parameters */
	  	  parameters  : {
		    space :  space,
			form_token : "4ztccRAVLWxtJHO8both1A",
			action : 'deleteforum'
	      },
          onCreate : function(){
            $elem.clickDesibled = true;
          },
          onSuccess : function() {
            /* Refressh the livetable */
            forums.refreshLiveTable();
          },
          onComplete : function() {
            $elem.clickDesibled = false;
          }
        },
        {
          confirmationText: "Delete this forum?",
          progressMessageText : "Delete in progress ...",
          successMessageText : "Forum deleted ",
          failureMessageText : "The forum could not be deleted"
        }
      );
    }
  }
  /* Observes the displayComplete of the livetable in ordert to attach
     click event on delete forum links */
  document.observe("xwiki:livetable:displayComplete", function(event){
    /* We need to check if the displayComplete is fired for the right table */
    if(event.memo.tableId == forums.tableId){
      $$('#' + forums.tableId + ' a.deleteforum').each(function(item){
        item.observe('click', function(){
	      forums.deleteForum(item);
        });
      });
	}
  });
})();
      

var XWiki = (function (XWiki) {
XWiki.EntryNamePopup = Class.create(XWiki.widgets.ModalPopup, {
  initialize : function($super, trigger) {
    trigger.observe('click', this.showDialog.bindAsEventListener(this));
    this.urlTemplate = trigger.up().next('input[type=hidden]').value;

    this.input = new Element('input', {type: 'text'});
    this.addButton = new Element('input', {type: 'image', src: '../../../resources/icons/silk/add.png', alt: 'Add'});

    var container = new Element('div', {id: 'entryNamePopup'});
    container.insert(this.input);
    container.insert(this.addButton);

    $super(container, {
      show: {method: this.showDialog, keys: []},
      add: {method: this._onAdd, keys: ['Enter']}
    }, {
      title: 'Entry name:',
      verticalPosition: 'top'
    });
  },
  createDialog : function($super, event) {
    this.addButton.observe('click', this._onAdd.bind(this));
    $super(event);
  },
  showDialog : function($super, event) {
    $super(event);
    this.input.clear().focus();
  },
  _onAdd : function() {
    if (this.input.value != '') {
      window.self.location = this.urlTemplate.replace('__entryName__', encodeURIComponent(this.input.value)).replace('__entryName__', encodeURIComponent(this.input.value));
    } else {
      this.input.focus();
    }
  }
});

function init() {
  var actionBox = $('actionBox');
  if(actionBox) {
    new XWiki.EntryNamePopup(actionBox.down('.add'));
    return true;
  }
  return false;
}
(XWiki.domIsLoaded && init()) || document.observe('xwiki:dom:loaded', init);

return XWiki;
}(XWiki || {}));
      
