var XWiki = (function (XWiki) {

/**
 * Make sure the 'Next Step' wizard button behaves as the 'Save & View' form action button. It's not enough to share
 * the same name, it must also fire the 'xwiki:actions:save' event with the right parameters. We could have fired the
 * event when the 'Next Step' button was clicked but we preferred to reuse the 'Save & View' button in order to avoid
 * duplicating the code from actionButtons.js.
 */
function enhanceNextStepButton(nextStepButton, actionButtons) {
  var saveAndViewButton = actionButtons.down("input[name$='action_save']");
  // Replace the 'Next Step' button with the 'Save & View' button.
  nextStepButton.insert({before: saveAndViewButton}).remove();
  Object.extend(saveAndViewButton, {
    id: nextStepButton.id,
    value: nextStepButton.value,
    title: nextStepButton.title,
    className: nextStepButton.className
  });
}

function init() {
  var form = $('inline');
  if (!form) {
    return false;
  }

  var nextStepButton = $('wizard-next');
  if (!nextStepButton) {
    return false;
  }

  // Hide the form action buttons because the wizard has its own buttons.
  var actionButtons = form.down('.bottombuttons').hide();

  // Make sure the 'Next Step' wizard button behaves as the 'Save & View' form action button.
  // We defer the call to be sure that the 'Save & View' button is initialized.
  enhanceNextStepButton.defer(nextStepButton, actionButtons);

  return true;
}
(XWiki.domIsLoaded && init()) || document.observe('xwiki:dom:loaded', init);

return XWiki;
}(XWiki || {}));
